/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.DrawPanel;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import model.Values;

public class MainFrame
extends JFrame {
    private Values values = new Values();
    private JTextField dichteTextField;
    private DrawPanel drawPanel1;
    private JTextField gewProTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JButton prozentButton;
    private JTextField volProTextField;

    public MainFrame() throws IOException {
        this.initComponents();
        this.setTitle("Alkoholgehalt");
        try {
            this.values.initList(this.getClass().getResourceAsStream("/ressources/EthanolDichte.txt"));
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Die Datei \"EthanolDichte.txt\" wurde nicht gefunden", "Datei nicht gefunden !", 0);
        }
        this.prozentButton.setVisible(false);
        this.drawPanel1.setValues(this.values);
        this.dichteTextField.requestFocus();
        this.repaint();
    }

    private void initComponents() {
        this.drawPanel1 = new DrawPanel();
        this.jLabel1 = new JLabel();
        this.dichteTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.gewProTextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.volProTextField = new JTextField();
        this.prozentButton = new JButton();
        this.jLabel4 = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setMinimumSize(new Dimension(700, 500));
        this.drawPanel1.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout drawPanel1Layout = new GroupLayout(this.drawPanel1);
        this.drawPanel1.setLayout(drawPanel1Layout);
        drawPanel1Layout.setHorizontalGroup(drawPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        drawPanel1Layout.setVerticalGroup(drawPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 459, Short.MAX_VALUE));
        this.jLabel1.setFont(new Font("Times New Roman", 1, 18));
        this.jLabel1.setText("Dichte:");
        this.dichteTextField.setFont(new Font("Times New Roman", 1, 18));
        this.dichteTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                MainFrame.this.dichteTextFieldFocusGained(evt);
            }
        });
        this.dichteTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.dichteTextFieldActionPerformed(evt);
            }
        });
        this.jLabel2.setFont(new Font("Times New Roman", 1, 18));
        this.jLabel2.setText("Massenprozent:");
        this.gewProTextField.setFont(new Font("Times New Roman", 1, 18));
        this.gewProTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                MainFrame.this.gewProTextFieldFocusGained(evt);
            }
        });
        this.gewProTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.gewProTextFieldActionPerformed(evt);
            }
        });
        this.jLabel3.setFont(new Font("Times New Roman", 1, 18));
        this.jLabel3.setText("Volumenprozent:");
        this.volProTextField.setFont(new Font("Times New Roman", 1, 18));
        this.volProTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                MainFrame.this.volProTextFieldFocusGained(evt);
            }
        });
        this.volProTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.volProTextFieldActionPerformed(evt);
            }
        });
        this.prozentButton.setFont(new Font("Times New Roman", 1, 18));
        this.prozentButton.setText("Prozente rechnen");
        this.prozentButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.prozentButtonActionPerformed(evt);
            }
        });
        this.jLabel4.setFont(new Font("Times New Roman", 1, 36));
        this.jLabel4.setHorizontalAlignment(0);
        this.jLabel4.setText("Alkoholgehalt");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.drawPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -1, 356, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jLabel2, -1, 356, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jLabel3, -1, 358, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.dichteTextField).addGap(18, 18, 18).addComponent(this.gewProTextField).addGap(18, 18, 18).addComponent(this.volProTextField))).addGap(18, 18, 18).addComponent(this.prozentButton, -1, 342, Short.MAX_VALUE))).addContainerGap()).addComponent(this.jLabel4, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel4, -2, 53, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.drawPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1, -2, 23, -2).addComponent(this.jLabel2, -2, 23, -2).addComponent(this.jLabel3, -2, 23, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dichteTextField, -2, -1, -2).addComponent(this.gewProTextField, -2, -1, -2).addComponent(this.volProTextField, -2, -1, -2))).addComponent(this.prozentButton, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void prozentButtonActionPerformed(ActionEvent evt) {
        if (this.dichteTextField.getText().equals("") && this.gewProTextField.getText().equals("") && this.volProTextField.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Geben sie bitte einen richtigen Wert an.", "Kein Wert gefunden !", 0);
        } else if (this.dichteTextField.getText().equals("") && this.gewProTextField.getText().equals("")) {
            if (Double.valueOf(this.volProTextField.getText().replace(",", ".")) >= 0.0 && Double.valueOf(this.volProTextField.getText().replace(",", ".")) <= 100.0) {
                this.volProTextField.setText(this.volProTextField.getText().replace(",", "."));
                this.dichteTextField.setText("" + this.values.getDichteWithGivenVol(Double.valueOf(this.volProTextField.getText().replace(",", "."))));
                this.gewProTextField.setText("" + this.values.getGewWithGivenVol(Double.valueOf(this.volProTextField.getText().replace(",", "."))) + "%");
                this.drawPanel1.setDichte(Double.valueOf(this.dichteTextField.getText().replace(",", ".")));
            } else {
                JOptionPane.showMessageDialog(this, "Der angegebene Volumenprozent ist nicht korrekt!", "Geben sie bitte einen richtigen Wert an.", 0);
            }
        } else if (this.dichteTextField.getText().equals("") && this.volProTextField.getText().equals("") && !this.gewProTextField.getText().equals("")) {
            if (Double.valueOf(this.gewProTextField.getText().replace(",", ".")) >= 0.0 && Double.valueOf(this.gewProTextField.getText().replace(",", ".")) <= 100.0) {
                this.gewProTextField.setText(this.gewProTextField.getText().replace(",", "."));
                this.dichteTextField.setText("" + this.values.getDichteWithGivenGew(Double.valueOf(this.gewProTextField.getText().replace(",", "."))));
                this.volProTextField.setText("" + this.values.getVolWithGivenGew(Double.valueOf(this.gewProTextField.getText().replace(",", "."))) + "%");
                this.drawPanel1.setDichte(Double.valueOf(this.dichteTextField.getText().replace(",", ".")));
            } else {
                JOptionPane.showMessageDialog(this, "Der angegebene Massenprozent ist nicht korrekt!", "Geben sie bitte einen richtigen Wert an.", 0);
            }
        } else if (this.gewProTextField.getText().equals("") && this.volProTextField.getText().equals("")) {
            if (Double.valueOf(this.dichteTextField.getText().replace(",", ".")) >= 0.79074 && Double.valueOf(this.dichteTextField.getText().replace(",", ".")) <= 1.0) {
                this.dichteTextField.setText(this.dichteTextField.getText().replace(",", "."));
                this.volProTextField.setText("" + this.values.getVolWithGivenDichte(Double.valueOf(this.dichteTextField.getText().replace(",", "."))) + "%");
                this.gewProTextField.setText("" + this.values.getGewWithGivenDichte(Double.valueOf(this.dichteTextField.getText().replace(",", "."))) + "%");
                this.drawPanel1.setDichte(Double.valueOf(this.dichteTextField.getText().replace(",", ".")));
            } else {
                JOptionPane.showMessageDialog(this, "Die angegebene Dichte ist nicht korrekt!", "Geben sie bitte einen richtigen Wert an.", 0);
            }
        }
        this.repaint();
    }

    private void dichteTextFieldActionPerformed(ActionEvent evt) {
        this.volProTextField.setText("");
        this.gewProTextField.setText("");
        this.prozentButton.doClick();
    }

    private void gewProTextFieldActionPerformed(ActionEvent evt) {
        this.dichteTextField.setText("");
        this.volProTextField.setText("");
        this.prozentButton.doClick();
    }

    private void volProTextFieldActionPerformed(ActionEvent evt) {
        this.dichteTextField.setText("");
        this.gewProTextField.setText("");
        this.prozentButton.doClick();
    }

    private void dichteTextFieldFocusGained(FocusEvent evt) {
        this.dichteTextField.selectAll();
    }

    private void gewProTextFieldFocusGained(FocusEvent evt) {
        this.gewProTextField.selectAll();
    }

    private void volProTextFieldFocusGained(FocusEvent evt) {
        this.volProTextField.selectAll();
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    MainFrame mainFrame = new MainFrame();
                    mainFrame.setVisible(true);
                    mainFrame.setExtendedState(6);
                    URL myurlIMG = this.getClass().getResource("/ressources/mainIcon.png");
                    BufferedImage image = ImageIO.read(myurlIMG);
                    mainFrame.setIconImage(image);
                }
                catch (IOException ex) {
                    Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
    }
}

