/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import model.Value;

public class Values {
    private ArrayList<Value> alValues = new ArrayList();

    public void initList(InputStream input_Stream) throws FileNotFoundException, IOException {
        this.alValues = new ArrayList();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(input_Stream));){
            String line;
            while ((line = in.readLine()) != null) {
                String[] value = line.split("\\;");
                Double dichte = Double.valueOf(value[0]);
                Double gewProEthanol = Double.valueOf(value[1]);
                Double volProEthanol = Double.valueOf(value[2]);
                this.alValues.add(new Value(dichte, gewProEthanol, volProEthanol));
            }
        }
    }

    public int size() {
        return this.alValues.size();
    }

    public void print() {
        for (int i = 0; i < this.alValues.size(); ++i) {
            System.out.println("Dichte :" + this.alValues.get((int)i).dichte + " --> GewProEthanol :" + this.alValues.get((int)i).gewProEthanol + " --> VolProEthanol :" + this.alValues.get((int)i).volProEthanol);
        }
    }

    public double getDouble(String value) {
        Double number = Double.valueOf(value);
        return (double)((int)(number * 1000.0)) / 1000.0;
    }

    public double getP(double x1, double y1, double x2, double y2) {
        return (y2 - y1) / (x2 - x1);
    }

    public double getDichteWithGivenGew(double givenValue) {
        boolean found = false;
        double dichte = -1.0;
        for (int i = 0; !found && i < this.size(); ++i) {
            if (this.alValues.get((int)i).gewProEthanol == givenValue) {
                found = !found;
                dichte = this.alValues.get((int)i).dichte;
                continue;
            }
            if (!(this.alValues.get((int)i).gewProEthanol > givenValue)) continue;
            found = !found;
            double p = this.getP(this.alValues.get((int)(i - 1)).dichte, this.alValues.get((int)(i - 1)).gewProEthanol, this.alValues.get((int)i).dichte, this.alValues.get((int)i).gewProEthanol);
            dichte = (givenValue - this.alValues.get((int)(i - 1)).gewProEthanol) / p + this.alValues.get((int)(i - 1)).dichte;
        }
        return this.getDouble(String.valueOf(dichte));
    }

    public double getDichteWithGivenVol(double givenValue) {
        boolean found = false;
        double dichte = -1.0;
        for (int i = 0; !found && i < this.size(); ++i) {
            if (this.alValues.get((int)i).volProEthanol == givenValue) {
                found = !found;
                dichte = this.alValues.get((int)i).dichte;
                continue;
            }
            if (!(this.alValues.get((int)i).volProEthanol > givenValue)) continue;
            found = !found;
            double p = this.getP(this.alValues.get((int)(i - 1)).dichte, this.alValues.get((int)(i - 1)).volProEthanol, this.alValues.get((int)i).dichte, this.alValues.get((int)i).volProEthanol);
            dichte = (givenValue - this.alValues.get((int)(i - 1)).volProEthanol) / p + this.alValues.get((int)(i - 1)).dichte;
        }
        return this.getDouble(String.valueOf(dichte));
    }

    public double getVolWithGivenGew(double givenValue) {
        boolean found = false;
        double dichte = this.getDichteWithGivenGew(givenValue);
        double vol = -1.0;
        for (int i = 0; !found && i < this.size(); ++i) {
            if (this.alValues.get((int)i).dichte == dichte) {
                found = !found;
                vol = this.alValues.get((int)i).volProEthanol;
                continue;
            }
            if (!(this.alValues.get((int)i).dichte < dichte)) continue;
            found = !found;
            double p = this.getP(this.alValues.get((int)(i - 1)).dichte, this.alValues.get((int)(i - 1)).volProEthanol, this.alValues.get((int)i).dichte, this.alValues.get((int)i).volProEthanol);
            vol = (dichte - this.alValues.get((int)(i - 1)).dichte) * p + this.alValues.get((int)(i - 1)).volProEthanol;
        }
        return this.getDouble(String.valueOf(vol));
    }

    public double getGewWithGivenVol(double givenValue) {
        boolean found = false;
        double dichte = this.getDichteWithGivenVol(givenValue);
        double vol = -1.0;
        for (int i = 0; !found && i < this.size(); ++i) {
            if (this.alValues.get((int)i).dichte == dichte) {
                found = !found;
                vol = this.alValues.get((int)i).gewProEthanol;
                continue;
            }
            if (!(this.alValues.get((int)i).dichte < dichte)) continue;
            found = !found;
            double p = this.getP(this.alValues.get((int)(i - 1)).dichte, this.alValues.get((int)(i - 1)).gewProEthanol, this.alValues.get((int)i).dichte, this.alValues.get((int)i).gewProEthanol);
            vol = (dichte - this.alValues.get((int)(i - 1)).dichte) * p + this.alValues.get((int)(i - 1)).gewProEthanol;
        }
        return this.getDouble(String.valueOf(vol));
    }

    public double getVolWithGivenDichte(double givenValue) {
        boolean found = false;
        double dichte = givenValue;
        double vol = -1.0;
        for (int i = 0; !found && i < this.size(); ++i) {
            if (this.alValues.get((int)i).dichte == dichte) {
                found = !found;
                vol = this.alValues.get((int)i).volProEthanol;
                continue;
            }
            if (!(this.alValues.get((int)i).dichte < dichte)) continue;
            found = !found;
            double p = this.getP(this.alValues.get((int)(i - 1)).dichte, this.alValues.get((int)(i - 1)).volProEthanol, this.alValues.get((int)i).dichte, this.alValues.get((int)i).volProEthanol);
            vol = (dichte - this.alValues.get((int)(i - 1)).dichte) * p + this.alValues.get((int)(i - 1)).volProEthanol;
        }
        return this.getDouble(String.valueOf(vol));
    }

    public double getGewWithGivenDichte(double givenValue) {
        boolean found = false;
        double dichte = givenValue;
        double gew = -1.0;
        for (int i = 0; !found && i < this.size(); ++i) {
            if (this.alValues.get((int)i).dichte == dichte) {
                found = !found;
                gew = this.alValues.get((int)i).gewProEthanol;
                continue;
            }
            if (!(this.alValues.get((int)i).dichte < dichte)) continue;
            found = !found;
            double p = this.getP(this.alValues.get((int)(i - 1)).dichte, this.alValues.get((int)(i - 1)).gewProEthanol, this.alValues.get((int)i).dichte, this.alValues.get((int)i).gewProEthanol);
            gew = (dichte - this.alValues.get((int)(i - 1)).dichte) * p + this.alValues.get((int)(i - 1)).gewProEthanol;
        }
        return this.getDouble(String.valueOf(gew));
    }

    public void draw(Graphics2D g, int width, int height, double givenDichte) {
        int i;
        int i2;
        double diffX = Math.abs((double)((int)((double)width / 21.0)) - (double)(width * 20) / 21.0);
        double diffY = Math.abs((double)(height * 1) / 7.0 - (double)(height * 6) / 7.0);
        g.setColor(Color.BLACK);
        g.drawLine((int)((double)width / 21.0), (int)((double)(height * 1) / 7.0), (int)((double)width / 21.0), (int)((double)(height * 6) / 7.0));
        g.drawLine((int)((double)width / 21.0), (int)((double)(height * 6) / 7.0), (int)((double)(width * 20) / 21.0), (int)((double)(height * 6) / 7.0));
        g.setColor(Color.RED);
        g.drawLine((int)((double)width / 21.0 + 10.0), (int)((double)(height * 6) / 7.0 - diffY * 0.5 / 20.0), (int)((double)width / 21.0 + 50.0), (int)((double)(height * 6) / 7.0 - diffY * 0.5 / 20.0));
        g.setColor(Color.GREEN);
        g.drawLine((int)((double)width / 21.0 + 10.0), (int)((double)(height * 6) / 7.0 - diffY * 1.5 / 20.0), (int)((double)width / 21.0 + 50.0), (int)((double)(height * 6) / 7.0 - diffY * 1.5 / 20.0));
        g.setColor(Color.BLACK);
        g.drawString("Massenprozent", (int)((double)width / 21.0 + 70.0), (int)((double)(height * 6) / 7.0 - diffY * 0.5 / 20.0 + 6.0));
        g.drawString("Volumenprozent", (int)((double)width / 21.0 + 70.0), (int)((double)(height * 6) / 7.0 - diffY * 1.5 / 20.0 + 6.0));
        g.drawString("D i c h t e", (int)((double)width / 21.0 + diffX * 10.5 / 21.0), (int)((double)(height * 6) / 7.0) + 40);
        g.setColor(Color.RED);
        for (i2 = this.alValues.size() - 1; i2 > 0; --i2) {
            double varGew = this.getGewWithGivenDichte(this.alValues.get((int)i2).dichte) / 5.0;
            double varOldGew = this.getGewWithGivenDichte(this.alValues.get((int)(i2 - 1)).dichte) / 5.0;
            g.drawLine((int)((double)width / 21.0 + diffX * ((this.alValues.get((int)i2).dichte - 0.79) * 100.0) / 21.0), (int)((double)(height * 6) / 7.0 - diffY * varGew / 20.0), (int)((double)width / 21.0 + diffX * ((this.alValues.get((int)(i2 - 1)).dichte - 0.79) * 100.0) / 21.0), (int)((double)(height * 6) / 7.0 - diffY * varOldGew / 20.0));
        }
        g.setColor(Color.GREEN);
        for (i2 = this.alValues.size() - 1; i2 > 0; --i2) {
            double varVol = this.getVolWithGivenDichte(this.alValues.get((int)i2).dichte) / 5.0;
            double varOldVol = this.getVolWithGivenDichte(this.alValues.get((int)(i2 - 1)).dichte) / 5.0;
            g.drawLine((int)((double)width / 21.0 + diffX * ((this.alValues.get((int)i2).dichte - 0.79) * 100.0) / 21.0), (int)((double)(height * 6) / 7.0 - diffY * varVol / 20.0), (int)((double)width / 21.0 + diffX * ((this.alValues.get((int)(i2 - 1)).dichte - 0.79) * 100.0) / 21.0), (int)((double)(height * 6) / 7.0 - diffY * varOldVol / 20.0));
        }
        if (givenDichte >= 0.79 && givenDichte <= 1.0) {
            g.setColor(Color.RED);
            double varVol = this.getVolWithGivenDichte(givenDichte) / 5.0;
            double varGew = this.getGewWithGivenDichte(givenDichte) / 5.0;
            g.fillOval((int)((double)width / 21.0 + diffX * ((givenDichte - 0.79) * 100.0) / 21.0) - 5, (int)((double)(height * 6) / 7.0 - diffY * varVol / 20.0) - 5, 8, 8);
            g.fillOval((int)((double)width / 21.0 + diffX * ((givenDichte - 0.79) * 100.0) / 21.0) - 5, (int)((double)(height * 6) / 7.0 - diffY * varGew / 20.0) - 5, 8, 8);
        }
        g.setColor(Color.BLACK);
        float[] dash1 = new float[]{2.0f, 0.0f, 2.0f};
        BasicStroke bs1 = new BasicStroke(1.0f, 1, 0, 1.0f, dash1, 2.0f);
        g.setStroke(bs1);
        for (i = 0; i <= 21; ++i) {
            g.drawLine((int)((double)width / 21.0 + diffX * (double)i / 21.0), (int)((double)(height * 1) / 7.0), (int)((double)width / 21.0 + diffX * (double)i / 21.0), (int)((double)(height * 6) / 7.0));
            g.drawString("" + this.getDouble("" + (0.79 + (double)i * 0.01)), (int)((double)width / 21.0 + diffX * (double)i / 21.0), (int)((double)(height * 6) / 7.0) + 20);
        }
        for (i = 0; i <= 20; ++i) {
            g.drawLine((int)((double)width / 21.0), (int)((double)(height * 6) / 7.0 - diffY * (double)i / 20.0), (int)((double)(width * 20) / 21.0), (int)((double)(height * 6) / 7.0 - diffY * (double)i / 20.0));
            g.drawString("" + i * 5, (int)((double)width / 21.0) - 20, (int)((double)(height * 6) / 7.0 - diffY * (double)i / 20.0));
        }
    }
}

