/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.DrawPanel;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import model.Angle;

public class MainFrame
extends JFrame {
    private Angle angle;
    private JLabel angleLabel;
    private JSlider angleSlider;
    private DrawPanel drawPanel;
    private JLabel jLabel1;

    public MainFrame() {
        this.initComponents();
        this.setTitle("Trigonometric Circle");
        this.updateView();
    }

    public void updateView() {
        this.angle = new Angle(this.angleSlider.getValue());
        this.drawPanel.setAngle(this.angle);
        this.angleLabel.setText(String.valueOf(this.angleSlider.getValue()));
        this.drawPanel.repaint();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.angleLabel = new JLabel();
        this.angleSlider = new JSlider();
        this.drawPanel = new DrawPanel();
        this.setDefaultCloseOperation(3);
        this.setTitle("Trigonometric Circle");
        this.setBackground(new Color(255, 255, 153));
        this.jLabel1.setText("Angle (degrees) :");
        this.angleLabel.setText("-");
        this.angleSlider.setMajorTickSpacing(45);
        this.angleSlider.setMaximum(360);
        this.angleSlider.setMinimum(-360);
        this.angleSlider.setMinorTickSpacing(10);
        this.angleSlider.setPaintLabels(true);
        this.angleSlider.setPaintTicks(true);
        this.angleSlider.setValue(45);
        this.angleSlider.setCursor(new Cursor(0));
        this.angleSlider.setValueIsAdjusting(true);
        this.angleSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MainFrame.this.angleSliderStateChanged(evt);
            }
        });
        GroupLayout drawPanelLayout = new GroupLayout(this.drawPanel);
        this.drawPanel.setLayout(drawPanelLayout);
        drawPanelLayout.setHorizontalGroup(drawPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        drawPanelLayout.setVerticalGroup(drawPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 700, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.angleSlider, -1, 680, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(18, 18, 18).addComponent(this.angleLabel, -2, 50, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()).addComponent(this.drawPanel, -1, 700, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.angleLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.angleSlider, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.drawPanel, -1, 700, Short.MAX_VALUE)));
        this.pack();
    }

    private void angleSliderStateChanged(ChangeEvent evt) {
        this.updateView();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MainFrame().setVisible(true);
            }
        });
    }
}

