/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class Angle {
    private double degrees;

    public Angle(double value) {
        this.degrees = value;
    }

    public double getRadians() {
        double radians = Math.PI / 180 * this.degrees;
        return radians;
    }

    public void setRadians(double value) {
        this.degrees = Math.PI / 180 * value;
    }

    public void setDegrees(double value) {
        this.degrees = value;
    }

    public double getDegrees() {
        return this.degrees;
    }

    public double getSin() {
        return Math.sin(this.getRadians());
    }

    public double getCos() {
        return Math.cos(this.getRadians());
    }

    public double getTan() {
        return Math.tan(this.getRadians());
    }

    public double getAtan() {
        return Math.atan(this.getRadians());
    }

    public void draw(Graphics g, int width, int height) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(new BasicStroke(2.0f));
        g.setColor(Color.lightGray);
        g.drawOval((width - 1) / 2 - (height - 1) / 4, (height - 1) / 2 - (height - 1) / 4, (height - 1) / 2, (height - 1) / 2);
        g.drawLine((width - 1) / 2, 0, (width - 1) / 2, height - 1);
        g.drawLine(0, (height - 1) / 2, width - 1, (height - 1) / 2);
        g.drawLine((width - 1) / 2 + (height - 1) / 4, 0, (width - 1) / 2 + (height - 1) / 4, height - 1);
        g.drawLine(0, (height - 1) / 4, width - 1, (height - 1) / 4);
        g.setColor(Color.lightGray);
        g.drawLine((width - 1) / 2, (int)((double)((height - 1) / 2) - this.getSin() * (double)(height - 1) / 4.0), (int)((double)((width - 1) / 2) + (double)((height - 1) / 4) * this.getCos()), (int)((double)((height - 1) / 2) - this.getSin() * (double)(height - 1) / 4.0));
        g.drawLine((int)((double)((width - 1) / 2) + (double)((height - 1) / 4) * this.getCos()), (height - 1) / 2, (int)((double)((width - 1) / 2) + (double)((height - 1) / 4) * this.getCos()), (int)((double)((height - 1) / 2) - this.getSin() * (double)(height - 1) / 4.0));
        g.drawLine((int)((double)((width - 1) / 2) + (double)((height - 1) / 4) * this.getCos()), (int)((double)((height - 1) / 2) - this.getSin() * (double)(height - 1) / 4.0), (width - 1) / 2 + (height - 1) / 4, (int)((double)((height - 1) / 2) + (double)((height - 1) / 4) * -this.getTan()));
        g.setColor(Color.RED);
        g.drawString("Angle (degrees) : " + this.degrees, 5, 20);
        g.drawString("Angle (radians)  : " + this.getRadians(), 5, 40);
        g.drawLine((width - 1) / 2, (height - 1) / 2, (int)((double)((width - 1) / 2) + (double)((height - 1) / 4) * this.getCos()), (int)((double)((height - 1) / 2) - this.getSin() * (double)(height - 1) / 4.0));
        g.setColor(Color.GREEN);
        g.drawString("Sinus                    : " + this.getSin(), 5, 60);
        g.drawLine((width - 1) / 2, (height - 1) / 2, (width - 1) / 2, (int)((double)((height - 1) / 2) - this.getSin() * (double)(height - 1) / 4.0));
        g.setColor(Color.BLUE);
        g.drawString("Cosinus               : " + this.getCos(), 5, 80);
        g.drawLine((width - 1) / 2, (height - 1) / 2, (int)((double)((width - 1) / 2) + (double)((height - 1) / 4) * this.getCos()), (height - 1) / 2);
        g.setColor(new Color(250, 120, 200));
        g.drawString("Tangens              : " + this.getTan(), 5, 100);
        g.drawLine((width - 1) / 2 + (height - 1) / 4, (height - 1) / 2, (width - 1) / 2 + (height - 1) / 4, (int)((double)((height - 1) / 2) + (double)((height - 1) / 4) * -this.getTan()));
    }
}

